//diagrama de pastel Tareas planificadas vs no planificadas
tareasPlanificadas = 12;
tareasNoPlanificadas = 12;
cronogramaTareas = 24;

//variables para mostrar los datos en miagrama
var datosDiagrama = null;
var myChartBar = null;

//realizar un ajax para consultar el total de los contratos, cantidad de contratos vencidos, suspendidos, finalizador y desactivados.
//select count(*) as total from servicios where estado = 1
//contarContratos
$(document).ready(function(){

  // Verificar si estamos en la página de inicio antes de ejecutar los gráficos
  if($('#myChart').length > 0 && $('#myChartBar').length > 0) {
    
    //obtener los datos del diagrama pastel
    var datos = new FormData();
    datos.append("contarcontratos", "hola");
    $.ajax({
    	url: "ajax/contratos.ajax.php",
    	 method: "POST",
      data: datos,
      cache: false,
      contentType: false,
      processData: false,
      dataType:"json",
    })
    .done(function(response) {
        console.log(response);
        diagramaPastel(response);
    })
    .fail(function() {
    	//console.log("error");
    })
    .always(function() {
    	//console.log("complete");
    });

    //obtener datos para gráfico de ingresos por zona
    obtenerIngresosPorZona();

    //obtener datos para gráfico de cobros diarios por zona (solo si existe el elemento)
    if($('#myChartTendencia').length > 0) {
      obtenerCobrosDiariosPorZona();
    }

    //obtener datos para gráfico de análisis mensual (solo si existe el elemento)
    if($('#myChartAnalisisMensual').length > 0) {
      obtenerAnalisisMensual();
    }

    //obtener datos para gráfico de cobros anuales por mes (solo si existe el elemento)
    if($('#myChartCobrosAnuales').length > 0) {
      obtenerCobrosAnualesPorMes();
    }

    //obtener datos para gráfico de recaudación por método de pago (solo si existe el elemento)
    if($('#myChartMetodoPago').length > 0) {
      obtenerRecaudacionPorMetodoPago();
    }
  }

});

// Removido el filtro de fechas para el gráfico de zonas


function diagramaPastel(datosDiagrama){
  // Verificar que existe el elemento del gráfico
  if(!document.getElementById('myChart')) {
    console.log("Elemento myChart no encontrado, saltando diagramaPastel");
    return;
  }
  
  var datosDiagrama = JSON.parse(datosDiagrama);
  var ctx = document.getElementById('myChart').getContext('2d');
  totalContratos = 0;
  totalFinalizados = 0;
  totalActivos = 0;
  totalSuspendidos = 0;
  totalDesactivados = 0;

  if(datosDiagrama != null){
    totalContratos = datosDiagrama['totalContratos'];
    totalFinalizados = datosDiagrama['totalFinalizados'];
    totalActivos = datosDiagrama['totalActivos'];
    totalSuspendidos = datosDiagrama['totalSuspendidos'];
    totalDesactivados = datosDiagrama['totalDesactivados'];
  }

  // Calcular porcentajes
  const calcularPorcentaje = (valor, total) => {
    return total > 0 ? ((valor / total) * 100).toFixed(1) : 0;
  };

  var myChart = new Chart(ctx, {
      type: 'doughnut', // Cambiar a doughnut para mejor visualización
      data: {
          labels: [
              `Activos: ${totalActivos} (${calcularPorcentaje(totalActivos, totalContratos)}%)`,
              `Suspendidos: ${totalSuspendidos} (${calcularPorcentaje(totalSuspendidos, totalContratos)}%)`,
              `Desactivados: ${totalDesactivados} (${calcularPorcentaje(totalDesactivados, totalContratos)}%)`,
              `Finalizados: ${totalFinalizados} (${calcularPorcentaje(totalFinalizados, totalContratos)}%)`
          ],
          datasets: [{
              label: 'Contratos por Estado',
              data: [totalActivos, totalSuspendidos, totalDesactivados, totalFinalizados],
              backgroundColor: [
                  '#28a745', // Verde para activos
                  '#ffc107', // Amarillo para suspendidos  
                  '#dc3545', // Rojo para desactivados
                  '#6c757d'  // Gris para finalizados
              ],
              borderColor: [
                  '#1e7e34',
                  '#e0a800', 
                  '#c82333',
                  '#545b62'
              ],
              borderWidth: 2,
              hoverBorderWidth: 3
          }]
      },
      options: {
          responsive: true,
          maintainAspectRatio: false,
          plugins: {
              title: {
                  display: true,
                  text: `Estado de Contratos - Total: ${totalContratos}`,
                  font: {
                      size: 16,
                      weight: 'bold'
                  }
              },
              legend: {
                  position: 'bottom',
                  labels: {
                      usePointStyle: true,
                      padding: 15,
                      font: {
                          size: 12
                      }
                  }
              },
              tooltip: {
                  callbacks: {
                      label: function(context) {
                          const label = context.label || '';
                          const value = context.parsed;
                          const percentage = calcularPorcentaje(value, totalContratos);
                          return `${label}: ${value} contratos (${percentage}%)`;
                      }
                  }
              }
          },
          animation: {
              animateRotate: true,
              duration: 1000
          }
      }
  });
}

function obtenerIngresosPorZona(){
  // Verificar que existe el elemento del gráfico
  if($('#myChartBar').length === 0) {
    console.log("Elemento myChartBar no encontrado, saltando obtenerIngresosPorZona");
    return;
  }
  
  var datos = new FormData();
  datos.append("ingresosporzona", "obtener");
  $.ajax({
    url: "ajax/contratos.ajax.php",
     method: "POST",
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    dataType:"json",
  })
  .done(function(response) {
      console.log("Ingresos por zona:", response);
      diagramaBarrasZonas(response);
  })
  .fail(function() {
    console.log("Error al obtener ingresos por zona");
  })
  .always(function() {
    //console.log("complete");
  });
}

function diagramaBarrasZonas(datosZonas){
  // Verificar que existe el elemento del gráfico
  if(!document.getElementById('myChartBar')) {
    console.log("Elemento myChartBar no encontrado, saltando diagramaBarrasZonas");
    return;
  }
  
  const formatterPeso = new Intl.NumberFormat('es-MX', {
     style: 'currency',
     currency: 'MXN',
     minimumFractionDigits: 0
   });

  console.log("Datos recibidos:", datosZonas);
  
  // Verificar si es string (JSON) y parsearlo
  if(typeof datosZonas === 'string') {
    try {
      datosZonas = JSON.parse(datosZonas);
    } catch(e) {
      console.error("Error al parsear JSON:", e);
      datosZonas = [];
    }
  }
  
  console.log("Datos procesados:", datosZonas);
  
  // Organizar datos por zona y estado
  let zonasDatos = {};
  let zonasSet = new Set();
  
  // Procesar datos para agrupar por zona
  if(datosZonas && Array.isArray(datosZonas) && datosZonas.length > 0){
    datosZonas.forEach(function(item) {
      const zona = item.nombre_zona;
      const estado = parseInt(item.estado);
      const cantidad = parseInt(item.cantidad) || 0;
      const monto = parseFloat(item.total_monto) || 0;
      
      zonasSet.add(zona);
      
      if(!zonasDatos[zona]) {
        zonasDatos[zona] = {
          pagado: 0,
          pendiente: 0,
          atrasado: 0,
          baja: 0,
          montoPagado: 0,
          montoPendiente: 0,
          montoAtrasado: 0,
          montoBaja: 0
        };
      }
      
      switch(estado) {
        case 1: // Pagado
          zonasDatos[zona].pagado = cantidad;
          zonasDatos[zona].montoPagado = monto;
          break;
        case 0: // Pendiente
          zonasDatos[zona].pendiente = cantidad;
          zonasDatos[zona].montoPendiente = monto;
          break;
        case 2: // Atrasado
          zonasDatos[zona].atrasado = cantidad;
          zonasDatos[zona].montoAtrasado = monto;
          break;
        case 4: // Baja
          zonasDatos[zona].baja = cantidad;
          zonasDatos[zona].montoBaja = monto;
          break;
      }
    });
  }

  // Preparar etiquetas (nombres de zonas)
  const etiquetas = Array.from(zonasSet).sort();
  
  // Preparar datasets para cada estado
  const datasets = [
    {
      label: 'Pagado',
      data: etiquetas.map(zona => zonasDatos[zona]?.pagado || 0),
      backgroundColor: '#28a745',
      borderColor: '#1e7e34',
      borderWidth: 1
    },
    {
      label: 'Pendiente',
      data: etiquetas.map(zona => zonasDatos[zona]?.pendiente || 0),
      backgroundColor: '#ffc107',
      borderColor: '#e0a800',
      borderWidth: 1
    },
    {
      label: 'Atrasado',
      data: etiquetas.map(zona => zonasDatos[zona]?.atrasado || 0),
      backgroundColor: '#dc3545',
      borderColor: '#c82333',
      borderWidth: 1
    },
    {
      label: 'Baja',
      data: etiquetas.map(zona => zonasDatos[zona]?.baja || 0),
      backgroundColor: '#6c757d',
      borderColor: '#545b62',
      borderWidth: 1
    }
  ];

  // Si no hay datos, mostrar mensaje
  if(etiquetas.length === 0) {
    etiquetas.push('Sin datos disponibles');
    datasets.forEach(dataset => {
      dataset.data = [0];
    });
  }

  // Destruir gráfico anterior si existe
  if(typeof myChartBar !== 'undefined' && myChartBar) {
    myChartBar.destroy();
  }

  // Crear gráfico de barras agrupadas
  var ctxBar = document.getElementById('myChartBar').getContext('2d');
  myChartBar = new Chart(ctxBar, {
    type: 'bar',
    data: {
        labels: etiquetas,
        datasets: datasets
    },
    options: {
        responsive: true,
        maintainAspectRatio: false,
        plugins: {
            title: {
                display: true,
                text: 'Estado de Pagos por Zona',
                font: {
                    size: 16,
                    weight: 'bold'
                }
            },
            legend: {
                display: true,
                position: 'top',
                labels: {
                    usePointStyle: true,
                    padding: 20
                }
            },
            tooltip: {
                callbacks: {
                    label: function(context) {
                        const zona = context.label;
                        const estado = context.dataset.label;
                        const cantidad = context.parsed.y;
                        
                        if(!zonasDatos[zona]) return `${estado}: ${cantidad}`;
                        
                        let monto = 0;
                        switch(estado) {
                            case 'Pagado':
                                monto = zonasDatos[zona].montoPagado;
                                break;
                            case 'Pendiente':
                                monto = zonasDatos[zona].montoPendiente;
                                break;
                            case 'Atrasado':
                                monto = zonasDatos[zona].montoAtrasado;
                                break;
                            case 'Baja':
                                monto = zonasDatos[zona].montoBaja;
                                break;
                        }
                        
                        return [
                            `${estado}: ${cantidad} pagos`,
                            `Monto: ${formatterPeso.format(monto)}`
                        ];
                    }
                }
            }
        },
        scales: {
            y: {
                beginAtZero: true,
                title: {
                    display: true,
                    text: 'Cantidad de Pagos'
                }
            },
            x: {
                title: {
                    display: true,
                    text: 'Zonas'
                }
            }
        },
        animation: {
            duration: 1000,
            easing: 'easeInOutQuart'
        }
    }
  });

}

function obtenerCobrosDiariosPorZona(){
  // Verificar que existe el elemento del gráfico
  if($('#myChartTendencia').length === 0) {
    console.log("Elemento myChartTendencia no encontrado, saltando obtenerCobrosDiariosPorZona");
    return;
  }
  
  var datos = new FormData();
  datos.append("cobrosdiarios", "obtener");
  
  $.ajax({
    url: "ajax/contratos.ajax.php",
    method: "POST",
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    dataType:"json",
  })
  .done(function(response) {
      console.log("Cobros diarios por zona:", response);
      diagramaCobrosDiarios(response);
  })
  .fail(function() {
    console.log("Error al obtener cobros diarios");
  })
  .always(function() {
    //console.log("complete");
  });
}

function diagramaCobrosDiarios(datosCobrosDiarios){
  // Verificar que existe el elemento del gráfico
  if(!document.getElementById('myChartTendencia')) {
    console.log("Elemento myChartTendencia no encontrado, saltando diagramaCobrosDiarios");
    return;
  }
  
  const formatterPeso = new Intl.NumberFormat('es-MX', {
     style: 'currency',
     currency: 'MXN',
     minimumFractionDigits: 0
   });

  console.log("Datos cobros diarios recibidos:", datosCobrosDiarios);
  
  // Verificar si es string (JSON) y parsearlo
  if(typeof datosCobrosDiarios === 'string') {
    try {
      datosCobrosDiarios = JSON.parse(datosCobrosDiarios);
    } catch(e) {
      console.error("Error al parsear JSON:", e);
      datosCobrosDiarios = [];
    }
  }
  
  // Organizar datos por zona y fecha
  let zonasDatos = {};
  let fechasSet = new Set();
  let zonasSet = new Set();
  
  // Procesar datos
  if(datosCobrosDiarios && Array.isArray(datosCobrosDiarios) && datosCobrosDiarios.length > 0){
    datosCobrosDiarios.forEach(function(item) {
      const fecha = item.fecha;
      const zona = item.nombre_zona;
      const cobros = parseInt(item.total_cobros) || 0;
      const monto = parseFloat(item.total_monto) || 0;
      
      fechasSet.add(fecha);
      zonasSet.add(zona);
      
      if(!zonasDatos[zona]) {
        zonasDatos[zona] = {};
      }
      
      zonasDatos[zona][fecha] = {
        cobros: cobros,
        monto: monto
      };
    });
  }

  // Preparar fechas ordenadas (últimos 15 días)
  const fechas = Array.from(fechasSet).sort();
  const zonas = Array.from(zonasSet).sort();
  
  // Colores para cada zona
  const colores = [
    '#17a2b8', '#28a745', '#dc3545', '#ffc107', 
    '#6f42c1', '#fd7e14', '#20c997', '#e83e8c'
  ];
  
  // Preparar datasets para cada zona
  const datasets = zonas.map((zona, index) => {
    const color = colores[index % colores.length];
    return {
      label: zona,
      data: fechas.map(fecha => {
        return zonasDatos[zona] && zonasDatos[zona][fecha] ? zonasDatos[zona][fecha].cobros : 0;
      }),
      borderColor: color,
      backgroundColor: color + '20',
      borderWidth: 3,
      fill: false,
      tension: 0.4,
      pointBackgroundColor: color,
      pointBorderColor: '#ffffff',
      pointBorderWidth: 2,
      pointRadius: 5,
      pointHoverRadius: 7
    };
  });

  // Si no hay datos, mostrar mensaje
  if(fechas.length === 0 || zonas.length === 0) {
    fechas.push('Sin datos');
    datasets.push({
      label: 'Sin datos disponibles',
      data: [0],
      borderColor: '#6c757d',
      backgroundColor: '#6c757d20'
    });
  }

  // Destruir gráfico anterior si existe
  if(typeof myChartTendencia !== 'undefined' && myChartTendencia) {
    myChartTendencia.destroy();
  }

  // Crear gráfico de líneas múltiples
  var ctx = document.getElementById('myChartTendencia').getContext('2d');
  var myChartTendencia = new Chart(ctx, {
    type: 'line',
    data: {
        labels: fechas,
        datasets: datasets
    },
    options: {
        responsive: true,
        maintainAspectRatio: false,
        plugins: {
            title: {
                display: true,
                text: 'Cobros Diarios por Zona (Últimos 15 Días)',
                font: {
                    size: 16,
                    weight: 'bold'
                }
            },
            legend: {
                display: true,
                position: 'top',
                labels: {
                    usePointStyle: true,
                    padding: 15
                }
            },
            tooltip: {
                callbacks: {
                    label: function(context) {
                        const zona = context.dataset.label;
                        const fecha = context.label;
                        const cobros = context.parsed.y;
                        
                        if(zonasDatos[zona] && zonasDatos[zona][fecha]) {
                            const monto = zonasDatos[zona][fecha].monto;
                            return [
                                `${zona}: ${cobros} cobros`,
                                `Monto: ${formatterPeso.format(monto)}`
                            ];
                        }
                        
                        return `${zona}: ${cobros} cobros`;
                    }
                }
            }
        },
        scales: {
            y: {
                beginAtZero: true,
                title: {
                    display: true,
                    text: 'Número de Cobros'
                },
                grid: {
                    color: 'rgba(0, 0, 0, 0.1)'
                }
            },
            x: {
                title: {
                    display: true,
                    text: 'Fecha'
                },
                grid: {
                    display: false
                }
            }
        },
        animation: {
            duration: 1000,
            easing: 'easeInOutQuart'
        },
        interaction: {
            intersect: false,
            mode: 'index'
        }
    }
  });
}

function obtenerAnalisisMensual(){
  // Verificar que existe el elemento del gráfico
  if($('#myChartAnalisisMensual').length === 0) {
    console.log("Elemento myChartAnalisisMensual no encontrado, saltando obtenerAnalisisMensual");
    return;
  }
  
  var datos = new FormData();
  datos.append("analisis-mensual", "obtener");
  
  $.ajax({
    url: "ajax/contratos.ajax.php",
    method: "POST",
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    dataType:"json",
  })
  .done(function(response) {
      console.log("Análisis mensual recibido:", response);
      diagramaAnalisisMensual(response);
  })
  .fail(function(xhr, status, error) {
    console.error("Error AJAX al obtener análisis mensual:", error);
    // Mostrar gráfico vacío en caso de error
    diagramaAnalisisMensual([]);
  })
  .always(function() {
    //console.log("complete");
  });
}

function diagramaAnalisisMensual(datosAnalisis){
  // Verificar que existe el elemento del gráfico
  if(!document.getElementById('myChartAnalisisMensual')) {
    console.log("Elemento myChartAnalisisMensual no encontrado, saltando diagramaAnalisisMensual");
    return;
  }
  
  const formatterPeso = new Intl.NumberFormat('es-MX', {
     style: 'currency',
     currency: 'MXN',
     minimumFractionDigits: 0
   });

  console.log("Datos análisis mensual recibidos:", datosAnalisis);
  
  // Verificar si es string (JSON) y parsearlo
  if(typeof datosAnalisis === 'string') {
    try {
      datosAnalisis = JSON.parse(datosAnalisis);
    } catch(e) {
      console.error("Error al parsear JSON:", e);
      datosAnalisis = [];
    }
  }
  
  // Preparar datos para el gráfico
  let etiquetas = [];
  let montos = [];
  let cantidades = [];
  let totalMonto = 0;
  
  // Colores específicos para cada categoría
  const colores = {
    'Pagos Realizados': '#28a745',      // Verde
    'Pagos Pendientes': '#ffc107',      // Amarillo
    'Pagos Atrasados': '#dc3545',       // Rojo
    'Bajas del Mes': '#6c757d'          // Gris
  };
  
  let backgroundColors = [];
  let borderColors = [];
  
  // Procesar datos reales de la base de datos
  if(datosAnalisis && Array.isArray(datosAnalisis) && datosAnalisis.length > 0){
    datosAnalisis.forEach(function(item) {
      const categoria = item.categoria;
      const monto = parseFloat(item.monto) || 0;
      const cantidad = parseInt(item.cantidad) || 0;
      
      etiquetas.push(categoria);
      montos.push(monto);
      cantidades.push(cantidad);
      totalMonto += monto;
      
      // Asignar colores según la categoría
      const color = colores[categoria] || '#6c757d';
      backgroundColors.push(color);
      borderColors.push(color);
    });
  } else {
    console.log("No hay datos para el mes actual");
    // Mostrar mensaje si no hay datos reales
    etiquetas = ['No hay datos para este mes'];
    montos = [0];
    cantidades = [0];
    backgroundColors = ['#6c757d'];
    borderColors = ['#6c757d'];
  }

  // Destruir gráfico anterior si existe
  if(typeof myChartAnalisisMensual !== 'undefined' && myChartAnalisisMensual) {
    myChartAnalisisMensual.destroy();
  }

  // Obtener mes actual
  const fechaActual = new Date();
  const nombreMes = fechaActual.toLocaleDateString('es-ES', { month: 'long', year: 'numeric' });

  // Crear gráfico de barras horizontales
  var ctx = document.getElementById('myChartAnalisisMensual').getContext('2d');
  var myChartAnalisisMensual = new Chart(ctx, {
    type: 'bar',
    data: {
        labels: etiquetas,
        datasets: [{
            label: 'Monto en MXN',
            data: montos,
            backgroundColor: backgroundColors,
            borderColor: borderColors,
            borderWidth: 2,
            borderRadius: 5,
            borderSkipped: false,
        }]
    },
    options: {
        indexAxis: 'y', // Barras horizontales
        responsive: true,
        maintainAspectRatio: false,
        plugins: {
            title: {
                display: true,
                text: `Análisis Financiero - ${nombreMes.charAt(0).toUpperCase() + nombreMes.slice(1)}`,
                font: {
                    size: 14,
                    weight: 'bold'
                }
            },
            legend: {
                display: false
            },
            tooltip: {
                callbacks: {
                    label: function(context) {
                        const categoria = context.label;
                        const monto = context.parsed.x;
                        const index = context.dataIndex;
                        const cantidad = cantidades[index];
                        const porcentaje = totalMonto > 0 ? ((monto / totalMonto) * 100).toFixed(1) : 0;
                        
                        return [
                            `${categoria}`,
                            `Monto: ${formatterPeso.format(monto)} (${porcentaje}%)`,
                            `Cantidad: ${cantidad} pagos`
                        ];
                    }
                }
            }
        },
        scales: {
            x: {
                beginAtZero: true,
                ticks: {
                    callback: function(value, index, values) {
                        return formatterPeso.format(value);
                    }
                },
                title: {
                    display: true,
                    text: 'Monto en Pesos Mexicanos'
                }
            },
            y: {
                title: {
                    display: true,
                    text: 'Categorías'
                }
            }
        },
        animation: {
            duration: 1000,
            easing: 'easeInOutQuart'
        }
    }
  });
}

//función para obtener cobros anuales por mes
function obtenerCobrosAnualesPorMes(){
  if($('#myChartCobrosAnuales').length === 0) return;
  
  var datos = new FormData();
  datos.append("cobros-anuales", true);

  $.ajax({
    url: "ajax/contratos.ajax.php",
    method: "POST",
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    dataType: "json",
    success: function(respuesta){
      console.log("Datos cobros anuales:", respuesta);
      if(respuesta && respuesta.length > 0) {
        diagramaCobrosAnuales(respuesta);
      } else {
        console.log("No hay datos de cobros anuales disponibles");
        mostrarMensajeVacio('myChartCobrosAnuales', 'No hay datos de cobros para este año');
      }
    },
    error: function(xhr, status, error) {
      console.error("Error al obtener cobros anuales:", error);
      mostrarMensajeVacio('myChartCobrosAnuales', 'Error al cargar datos de cobros anuales');
    }
  }).fail(function(xhr, status, error) {
    console.error("Error AJAX cobros anuales:", error);
    mostrarMensajeVacio('myChartCobrosAnuales', 'Error de conexión');
  });
}

//función para crear gráfico de cobros anuales por mes
function diagramaCobrosAnuales(datos){
  if(!document.getElementById('myChartCobrosAnuales')) return;
  
  const formatterPeso = new Intl.NumberFormat('es-MX', {
    style: 'currency',
    currency: 'MXN',
    minimumFractionDigits: 0
  });

  // Preparar datos para el gráfico
  const meses = datos.map(item => item.mes_nombre);
  const totales = datos.map(item => parseFloat(item.total_cobros) || 0);
  const cantidades = datos.map(item => parseInt(item.cantidad_cobros) || 0);

  // Colores para el gráfico de barras
  const colores = [
    '#3498db', '#e74c3c', '#2ecc71', '#f39c12', 
    '#9b59b6', '#1abc9c', '#34495e', '#e67e22',
    '#95a5a6', '#f1c40f', '#8e44ad', '#16a085'
  ];

  var ctx = document.getElementById('myChartCobrosAnuales').getContext('2d');
  
  new Chart(ctx, {
    type: 'bar',
    data: {
      labels: meses,
      datasets: [{
        label: 'Cobros Realizados',
        data: totales,
        backgroundColor: colores.slice(0, meses.length),
        borderColor: colores.slice(0, meses.length).map(color => color.replace('0.8', '1')),
        borderWidth: 2,
        borderRadius: 5,
        borderSkipped: false,
      }]
    },
    options: {
      responsive: true,
      maintainAspectRatio: false,
      plugins: {
        title: {
          display: true,
          text: 'Cobros Realizados por Mes - Año ' + new Date().getFullYear(),
          font: {
            size: 16,
            weight: 'bold'
          }
        },
        legend: {
          display: false
        },
        tooltip: {
          callbacks: {
            label: function(context) {
              const index = context.dataIndex;
              const monto = formatterPeso.format(totales[index]);
              const cantidad = cantidades[index];
              return [
                `Monto: ${monto}`,
                `Cantidad: ${cantidad} cobros`
              ];
            }
          }
        }
      },
      scales: {
        y: {
          beginAtZero: true,
          ticks: {
            callback: function(value) {
              return formatterPeso.format(value);
            }
          },
          title: {
            display: true,
            text: 'Monto en Pesos Mexicanos'
          }
        },
        x: {
          title: {
            display: true,
            text: 'Meses del Año'
          }
        }
      }
    }
  });
}

//función para obtener recaudación por método de pago
function obtenerRecaudacionPorMetodoPago(){
  if($('#myChartMetodoPago').length === 0) return;
  
  var datos = new FormData();
  datos.append("recaudacion-metodo", true);

  $.ajax({
    url: "ajax/contratos.ajax.php",
    method: "POST",
    data: datos,
    cache: false,
    contentType: false,
    processData: false,
    dataType: "json",
    success: function(respuesta){
      console.log("Datos recaudación método:", respuesta);
      if(respuesta && respuesta.length > 0) {
        diagramaRecaudacionMetodoPago(respuesta);
      } else {
        console.log("No hay datos de recaudación por método disponibles");
        mostrarMensajeVacio('myChartMetodoPago', 'No hay datos de recaudación por método de pago');
      }
    },
    error: function(xhr, status, error) {
      console.error("Error al obtener recaudación por método:", error);
      mostrarMensajeVacio('myChartMetodoPago', 'Error al cargar datos de recaudación');
    }
  }).fail(function(xhr, status, error) {
    console.error("Error AJAX recaudación método:", error);
    mostrarMensajeVacio('myChartMetodoPago', 'Error de conexión');
  });
}

//función para crear gráfico de recaudación por método de pago
function diagramaRecaudacionMetodoPago(datos){
  if(!document.getElementById('myChartMetodoPago')) return;
  
  const formatterPeso = new Intl.NumberFormat('es-MX', {
    style: 'currency',
    currency: 'MXN',
    minimumFractionDigits: 0
  });

  // Preparar datos para el gráfico
  const etiquetas = datos.map(item => {
    const metodo = item.metodo_pago || 'Sin especificar';
    const banco = item.banco || 'Sin banco';
    return `${metodo} - ${banco}`;
  });
  
  const totales = datos.map(item => parseFloat(item.total_recaudado) || 0);
  const cantidades = datos.map(item => parseInt(item.cantidad_transacciones) || 0);

  // Generar colores dinámicamente
  const colores = etiquetas.map((_, index) => {
    const hue = (index * 137.508) % 360; // Distribución áurea para colores
    return `hsla(${hue}, 70%, 60%, 0.8)`;
  });

  var ctx = document.getElementById('myChartMetodoPago').getContext('2d');
  
  new Chart(ctx, {
    type: 'doughnut',
    data: {
      labels: etiquetas,
      datasets: [{
        data: totales,
        backgroundColor: colores,
        borderColor: colores.map(color => color.replace('0.8', '1')),
        borderWidth: 2
      }]
    },
    options: {
      responsive: true,
      maintainAspectRatio: false,
      plugins: {
        title: {
          display: true,
          text: 'Recaudación por Método de Pago y Banco',
          font: {
            size: 16,
            weight: 'bold'
          }
        },
        legend: {
          position: 'bottom',
          labels: {
            boxWidth: 12,
            padding: 10,
            generateLabels: function(chart) {
              const data = chart.data;
              if (data.labels.length && data.datasets.length) {
                return data.labels.map((label, index) => {
                  const total = totales[index];
                  const porcentaje = ((total / totales.reduce((a, b) => a + b, 0)) * 100).toFixed(1);
                  return {
                    text: `${label} (${porcentaje}%)`,
                    fillStyle: data.datasets[0].backgroundColor[index],
                    strokeStyle: data.datasets[0].borderColor[index],
                    lineWidth: data.datasets[0].borderWidth,
                    hidden: false,
                    index: index
                  };
                });
              }
              return [];
            }
          }
        },
        tooltip: {
          callbacks: {
            label: function(context) {
              const index = context.dataIndex;
              const monto = formatterPeso.format(totales[index]);
              const cantidad = cantidades[index];
              const total = totales.reduce((a, b) => a + b, 0);
              const porcentaje = ((totales[index] / total) * 100).toFixed(1);
              
              return [
                `Monto: ${monto}`,
                `Transacciones: ${cantidad}`,
                `Porcentaje: ${porcentaje}%`
              ];
            }
          }
        }
      }
    }
  });
}
